//
//  load_config.h -- functions to load the configuration file
//  -- created 4/20/00  updated 5/9/00
////////////////////////////////////////////////////////////

#ifndef LOAD_CONFIG_H
#define LOAD_CONFIG_H
namespace std {};
using namespace std;

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include "support.h"
#include "Althea.h"
#include "Server.h"
#include "Configuration.h"
#include "registerwindow.h"
#include "crypto.h"
#include "promptwindow.h"

#define LOCAL_CONFIG_FILE ".althearc"
#define RC_CONFIG_FILE "/etc/althearc"

extern Althea gAlthea;

enum config_command 
{ 
  SERVER, EXPERT, CACHE, NOCOMMAND, FILTER, NAME, SMTPSERVER, IMAPSERVER,
  IMAPPORT, USERNAME, PASSWORD, MAILBOX, FCCFOLDER, SLASHSERVER, SLASHFILTER,
  FILTERFOLDER, FILTERSTRING, FIELD, EMAILADDRESS, CRYPTPASSWORD, SAVEPASSWORD,
  USESSL,CHECK_MAIL_KEY,DELETE_MESSAGE_KEY,FORWARD_MESSAGE_KEY,COMPOSE_MESSAGE_KEY,
  PRINT_MESSAGE_KEY,QUIT_ALTHEA_KEY,REPLY_MESSAGE_KEY,SAVE_MESSAGE_KEY,
  SEND_MESSAGE_KEY,ATTACH_FILE_KEY,CLOSE_MESSAGE_KEY
};

//  The master function that loads the configuration file into memory
int load_Althea();

// Other functions that will be used to load things into the data structure
void load_Server (const string & name, const string &smtp, const string &imap, const string & port, const string & username, const string & password, const string & folder_root, string & fccfolder, string & emailaddress, bool savepassword, bool usessl );
void load_Expert_Mode (int expert);
void load_Cache (int cache);
void load_Keystroke(keystrokes key, char accelerator);

//  Utility functions
config_command convert_upper_to_command(const string & upper_string);
string cfg_read_til_lessthan(ifstream *config_in, bool *done);
string cfg_read_til_lessthanslash(ifstream *config_in, bool *done);
string cfg_read_til_greaterthan(ifstream *config_in, bool *done);
string string_to_upper(string upper_string);
bool read_Server_XML(ifstream *config_in, string *name, string *smtp, string *imap, string *port, 
string *username, string *password, string *folder_root, string *fccfolder, string *emailaddress, bool *done, bool *savepassword, bool *usessl);
void read_Filter_XML(ifstream *config_in, string *field, string *filter_string, string *folder, bool *done);

#endif
