//
//  support.h  --  support functions for gtk parts of program
//  -- created 5/23/00  updated 1/17/00
///////////////////////////////////////////////

#ifndef SUPPORT_H
#define SUPPORT_H
namespace std {};
using namespace std;

#define VERSION "0.5.5"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include "callbacks.h"
#include <iostream.h>
#include <string>
#include <gtk/gtk.h>

#include "Althea.h"



// taken from balsa 1.1.7 (www.balsa.net)


enum {
    TARGET_MESSAGES
};

#define ELEMENTS(x) (sizeof (x) / sizeof (x[0]))



// end taken from balsa





string *extract_text( GtkText *the_widget );
string *extract_entry( GtkEntry *the_widget );
void error( string error_string );
GtkWidget *create_error_window( string error_string );
GtkCTreeNode *create_new_server( Server *the_server, GtkCTree *folder_list );
GtkCTreeNode *create_folder_in_server( Folder *the_folder, GtkCTreeNode *server );
GdkColor *new_color( int r, int g, int b );
void set_row_color( GtkCList *list, int row, int r, int g, int b );
void create_password_window( Server *the_server );

struct text_widgets {
  GtkEntry *to;
  GtkEntry *subject;
  GtkEntry *cc;
  GtkText *body;
};

struct server_text_widgets {
    GtkEntry *name;
    GtkEntry *imapserver;
    GtkEntry *imapport;
    GtkEntry *username;
    GtkEntry *password;
    GtkEntry *folderroot;
    GtkEntry *smtpserver;
    GtkEntry *sentmailfolder;
    GtkEntry *email;
    GtkCheckButton *savepassword;
    GtkCheckButton *usessl;
};
struct filter_text_widgets {
    GtkEntry *filter_field;
    GtkEntry *filter_string;
    GtkEntry *folder;
};


struct password_widgets {
  GtkWidget *password_text;
  Server *the_server;
};

/*
 * Public Functions.
 */

/*
 * This function returns a widget in a component created by Glade.
 * Call it with the toplevel widget in the component (i.e. a window/dialog),
 * or alternatively any widget in the component, and the name of the widget
 * you want returned.
 */
GtkWidget*  lookup_widget              (GtkWidget       *widget,
                                        const gchar     *widget_name);

/* get_widget() is deprecated. Use lookup_widget instead. */
#define get_widget lookup_widget

/* Use this function to set the directory containing installed pixmaps. */
void        add_pixmap_directory       (const gchar     *directory);


/*
 * Private Functions.
 */

/* This is used to create the pixmaps in the interface. */
GtkWidget*  create_pixmap              (GtkWidget       *widget,
                                        const gchar     *filename);
#endif
