# 2023-05-03 Triage Log

This week the good outweighed the bad. In particular, we had three different PRs
that made improvements to a wide range of benchmarks. Special call out to PR
[#111026](https://github.com/rust-lang/rust/pull/111026),
which yielded 3% to 8% improvement for incremental compile times on a large set
of benchmarks, by avoiding unnecessary caching in the type checker.

Triage done by **@pnkfelix**.
Revision range: [fdeef3ed..a368898d](https://perf.rust-lang.org/?start=fdeef3ed1809aa9bd4ea9ff0fad92010c6de669c&end=a368898de758e1b8def6c9060044a5b40eb79e84&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 0.9%]    | 30    |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.4%, 1.1%]    | 12    |
| Improvements ✅ <br /> (primary)   | -1.6% | [-8.8%, -0.3%]  | 115   |
| Improvements ✅ <br /> (secondary) | -1.5% | [-10.3%, -0.2%] | 92    |
| All ❌✅ (primary)                 | -1.1% | [-8.8%, 0.9%]   | 145   |


4 Regressions, 6 Improvements, 7 Mixed; 6 of them in rollups
56 artifact comparisons made in total

#### Regressions

Add loongarch64 asm! support [#101069](https://github.com/rust-lang/rust/pull/101069) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=91b61a4ad618c1abc2af43a58695de185ef1e513&end=999e6e5afb71d0fa6b5f67440278129aca12c67d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.2% | [1.1%, 2.9%] | 3     |
| Regressions ❌ <br /> (secondary)  | 4.9% | [0.3%, 8.2%] | 8     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 2.2% | [1.1%, 2.9%] | 3     |

* primary regressions are all in cranelift-codegen; secondary are in keccak and externs.
* already triaged.


Do not bother optimizing impossible functions. [#110728](https://github.com/rust-lang/rust/pull/110728) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e3ccd4b9a51ded19bf1c3f6c647c96b6dd52eced&end=8b8110e1469d459a196f6feb60d82dec48c3cfc2&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.4%, 0.5%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.2%, 0.4%] | 8     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.4%, 0.5%] | 3     |

* Seems like it didn't have the expected positive impact
* primary regressions are to libc; most of secondary are to variants many-assoc-items (plus some check incr-unchanged on three other secondaries).
* in any case, the measured impact looks negligible to me.
* marked as triaged

Rollup of 7 pull requests [#110896](https://github.com/rust-lang/rust/pull/110896) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6ce22733b973355573efd1e6294e585460e90e17&end=901fdb3b04375e3456b5cf771f86ecca8d6c1917&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [0.2%, 2.4%]   | 7     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | 0.4%  | [0.4%, 0.4%]   | 2     |

* primary regressions are to doc for syn and webrender. secondary that regressed by 2.4% was incr-unchanged for wg-grammar benchmarks.
* marking as triaged.

Rollup of 6 pull requests [#110924](https://github.com/rust-lang/rust/pull/110924) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=033aa092ab23ba14cdad27073c5e37ba0eddb428&end=2fce2290865f012391b8f3e581c3852a248031fa&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.4%, 0.7%] | 7     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.4%, 0.7%] | 7     |


* primary regressions are to debug profiles for serde_derive, hyper (plus noise from clap and cargo).
* we've recovered the loss on serde_derive since this commit landed, but not on hyper.
* from reviewing the PRs in the rollup, it does not seem like there's any real culprit here.
* marking as triaged.

#### Improvements

Allow older LLVM versions to have missing components [#110232](https://github.com/rust-lang/rust/pull/110232) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fdeef3ed1809aa9bd4ea9ff0fad92010c6de669c&end=f6830a212973ced91a047cee86cb79cee4f23868&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.7% | [-2.8%, -0.7%] | 4     |
| Improvements ✅ <br /> (secondary) | -6.0% | [-7.5%, -4.9%] | 6     |
| All ❌✅ (primary)                 | -1.7% | [-2.8%, -0.7%] | 4     |

* I don't understand why this had any impact at all, albeit positive. It looks like just some environment variable settings in the Dockerfiles.

Rewrite MemDecoder around pointers not a slice [#110634](https://github.com/rust-lang/rust/pull/110634) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=84d4f16728ed2e5a90c800d6d84225be3ca7c3c8&end=adaac6b166df57ea5a20d56e4cce503b55aca927&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.7%, -0.3%] | 52    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.8%, -0.3%] | 16    |
| All ❌✅ (primary)                 | -0.4% | [-0.7%, 0.4%]  | 53    |

* a broad collection of small improvements, nice!

Rollup of 10 pull requests [#110852](https://github.com/rust-lang/rust/pull/110852) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9c044d77a334609513f3b615e0763a40cc02424d&end=1c42cb4ef0544fbfaa500216e53382d6b079c001&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.4%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary)                 | -0.4% | [-0.5%, -0.4%] | 4     |


Remove `QueryEngine` trait [#109611](https://github.com/rust-lang/rust/pull/109611) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=87b1f891ea76713462cfc5a15137a8fe2b24ecc2&end=f5adff6bd8b29ac7dd173b36f0c8c35bb1c593c5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.8%, -0.2%] | 84    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.5%, -0.4%] | 32    |
| All ❌✅ (primary)                 | -0.6% | [-0.8%, -0.2%] | 84    |

* another broad collection of small improvements, good to see!

Only cache typeck results if it's the typeck root [#111026](https://github.com/rust-lang/rust/pull/111026) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2034b6d23ca18311a23273f2f08c381a04fa05d9&end=4b87ed9d0f18166a26aadb5289bac004e058b90f&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -1.8% | [-7.9%, -0.4%]  | 62    |
| Improvements ✅ <br /> (secondary) | -4.6% | [-11.5%, -1.0%] | 12    |
| All ❌✅ (primary)                 | -1.8% | [-7.9%, -0.4%]  | 62    |

* nice work! (sizeable, 3% to 8% improvement on a number of benchmarks for incr runs)

Make some simple queries no longer cache on disk [#111028](https://github.com/rust-lang/rust/pull/111028) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9d795a6e6e19d56b235d1dbd4f5941404cf5918c&end=a368898de758e1b8def6c9060044a5b40eb79e84&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 17    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.4%] | 9     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.3%] | 17    |


#### Mixed

Use MIR's `Offset` for pointer `add` too [#110837](https://github.com/rust-lang/rust/pull/110837) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2fce2290865f012391b8f3e581c3852a248031fa&end=43a78029b4f4d92978b8fde0a677ea300b113c41&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2%  | [0.9%, 1.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.4%, -0.5%] | 14    |
| Improvements ✅ <br /> (secondary) | -1.3% | [-2.0%, -0.5%] | 11    |
| All ❌✅ (primary)                 | -0.6% | [-1.4%, 1.4%]  | 16    |

* cute idea for a PR ("reduce your useless MIR with this small trick!")
* primary regressions are to serde_derive and webrender (opt-full for both).
* already triaged; improvements clearly outweigh the regressions here, at least based on the counts of number of impacted benchmarks.

Rollup of 8 pull requests [#110967](https://github.com/rust-lang/rust/pull/110967) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f4956053816439a5884cb2ad1247835858f92218&end=7a96158b53529c2dd03bb4a637d8589ac6f5376f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [0.4%, 2.0%]   | 17    |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [1.1%, 1.3%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 1.1%  | [0.4%, 2.0%]   | 17    |

* primary regression are to diesel, clap, and cranelift-codegen.
* lqd and compiler-errors are discussing on the PR.
* (pnkfelix is not convinced its a real regression that we can address, based on their conversation.)

Rollup of 6 pull requests [#110978](https://github.com/rust-lang/rust/pull/110978) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=572c0d553f2bd1b934b08fe240310112369a5c76&end=af2c7e0f9b5730b9598ca70fc67360fa69b469c8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.3%] | 2     |

* regressions are solely to secondary externs benchmark.
* its so minor. marking as triaged.

Improve niche placement by trying two strategies and picking the better result [#108106](https://github.com/rust-lang/rust/pull/108106) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=af2c7e0f9b5730b9598ca70fc67360fa69b469c8&end=f2299490c11b0c53ece5f6a13dd092fc9c99d264&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.6%]   | 7     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.4%, 1.0%]   | 12    |
| Improvements ✅ <br /> (primary)   | -2.6% | [-8.5%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-2.8%, -0.3%] | 31    |
| All ❌✅ (primary)                 | -0.7% | [-8.5%, 0.6%]  | 11    |

* addresses a real performance regression (#105371) to how we laid out niches.
* primary big benefit to syn. rest of primary changes may be noise; the secondary improvements are nice to have.
* marking as triaged.

Rollup of 6 pull requests [#110994](https://github.com/rust-lang/rust/pull/110994) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=27d22d2045478c544ad043556de4993eebe4be29&end=eb62877597000ccf8bb99ab131b5977344afdfa3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.4%, 0.7%]   | 3     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 0.5%  | [0.4%, 0.7%]   | 3     |

* primary regressions to doc for clap, stm32f4, cranelift-codegen
* already marked as triaged.

Make `mem::replace` simpler in codegen [#111010](https://github.com/rust-lang/rust/pull/111010) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b7d8c88b64843d05761576aa093a34a8bc176817&end=6db1e5e771cb810b22f4ff26f1346e386ca7643f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.6%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.5%]   | 2     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-1.8%, -1.0%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.7%, -0.4%] | 3     |
| All ❌✅ (primary)                 | -0.5% | [-1.8%, 0.6%]  | 6     |

* primary regressions to ripgrep opt-full, plus doc for hyper and html5ever.
* already marked as triaged.

Remove type ascription from parser and diagnostics [#109128](https://github.com/rust-lang/rust/pull/109128) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7b99493492ad59c7a44c65373558175db42b4151&end=98c33e47a495fbd7b22bce9ce32f2815991bc414&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 9     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.5%]   | 9     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.4%, -1.4%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.4%]   | 9     |

* primary regressions are to serde, hyper, diesel; mostly to incr-unchanged scenarios.
* surprising that this had this impact.
* i'm guessing this is noise (this change should be solely *simplifying* the compiler, AFAICT).
* marking as triaged.

#### Untriaged Pull Requests

- [#110978 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/110978)
- [#110967 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/110967)
- [#110924 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/110924)
- [#110896 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/110896)
- [#110728 Do not bother optimizing impossible functions.](https://github.com/rust-lang/rust/pull/110728)
- [#110546 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/110546)
- [#110542 resolve: Remove `module_children_untracked`](https://github.com/rust-lang/rust/pull/110542)
- [#110440 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/110440)
- [#110012 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/110012)
- [#109900 Only enable ConstProp at mir-opt-level >= 2.](https://github.com/rust-lang/rust/pull/109900)
- [#109692 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/109692)
- [#109588 Alloc `hir::Lit` in an arena to remove the destructor from `Expr`](https://github.com/rust-lang/rust/pull/109588)
- [#109247 Permit MIR inlining without #[inline]](https://github.com/rust-lang/rust/pull/109247)
- [#109128 Remove type ascription from parser and diagnostics](https://github.com/rust-lang/rust/pull/109128)
- [#109097 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/109097)
- [#108934 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/108934)
- [#108872 Strengthen state tracking in const-prop](https://github.com/rust-lang/rust/pull/108872)
- [#108830 Treat projections with infer as placeholder during fast reject in new solver](https://github.com/rust-lang/rust/pull/108830)
- [#108587 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/108587)
- [#108106 Improve niche placement by trying two strategies and picking the better result](https://github.com/rust-lang/rust/pull/108106)
- [#108080 Add a builtin `FnPtr` trait that is implemented for all function pointers](https://github.com/rust-lang/rust/pull/108080)
- [#108025 rustdoc: add more tooltips to intra-doc links](https://github.com/rust-lang/rust/pull/108025)
- [#107833 Factor query arena allocation out from query caches](https://github.com/rust-lang/rust/pull/107833)
- [#107783 rustdoc: simplify DOM for `.item-table`](https://github.com/rust-lang/rust/pull/107783)
- [#107765 rustc/rustdoc: Perform name resolver cleanups enabled by #94857](https://github.com/rust-lang/rust/pull/107765)
- [#107672 Rollup of 3 pull requests](https://github.com/rust-lang/rust/pull/107672)
- [#107408 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/107408)
- [#107404 Turn on ConstDebugInfo pass.](https://github.com/rust-lang/rust/pull/107404)
- [#107143 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/107143)
- [#107103 Use new solver in `evaluate_obligation` query (when new solver is enabled)](https://github.com/rust-lang/rust/pull/107103)
